/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container;

import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.Nullable;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.OptInCaching;
import org.picocontainer.lifecycle.ReflectionLifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonarsource.sonarlint.core.container.ComponentKeys;
import org.sonarsource.sonarlint.core.container.ContainerPopulator;
import org.sonarsource.sonarlint.core.container.PicoUtils;
import org.sonarsource.sonarlint.core.plugin.PluginInfo;

public class ComponentContainer
implements ContainerPopulator.Container {
    ComponentContainer parent;
    MutablePicoContainer pico;
    PropertyDefinitions propertyDefinitions;
    ComponentKeys componentKeys;

    public ComponentContainer() {
        this(ComponentContainer.createPicoContainer());
    }

    protected ComponentContainer(MutablePicoContainer picoContainer) {
        this.parent = null;
        this.pico = picoContainer;
        this.componentKeys = new ComponentKeys();
        this.propertyDefinitions = new PropertyDefinitions(new Object[0]);
        this.addSingleton(this.propertyDefinitions);
        this.addSingleton(this);
    }

    protected ComponentContainer(ComponentContainer parent) {
        this.parent = parent;
        this.pico = parent.makeChildContainer();
        this.propertyDefinitions = parent.propertyDefinitions;
        this.componentKeys = new ComponentKeys();
        this.addSingleton(this);
    }

    private synchronized MutablePicoContainer makeChildContainer() {
        return this.pico.makeChildContainer();
    }

    public void execute() {
        boolean threw = true;
        try {
            this.startComponents();
            threw = false;
        }
        finally {
            this.stopComponents(threw);
        }
    }

    public ComponentContainer startComponents() {
        try {
            this.doBeforeStart();
            this.pico.start();
            this.doAfterStart();
            return this;
        }
        catch (Exception e) {
            throw PicoUtils.propagate(e);
        }
    }

    protected void doBeforeStart() {
    }

    protected void doAfterStart() {
    }

    public ComponentContainer stopComponents() {
        return this.stopComponents(false);
    }

    public ComponentContainer stopComponents(boolean swallowException) {
        try {
            this.pico.stop();
            this.pico.dispose();
        }
        catch (RuntimeException e) {
            if (!swallowException) {
                throw PicoUtils.propagate(e);
            }
        }
        finally {
            if (this.parent != null) {
                this.parent.removeChildContainer(this.pico);
            }
        }
        return this;
    }

    private synchronized void removeChildContainer(MutablePicoContainer child) {
        this.pico.removeChildContainer(child);
    }

    @Override
    public ComponentContainer add(Object ... objects) {
        for (Object object : objects) {
            if (object instanceof ComponentAdapter) {
                this.addPicoAdapter((ComponentAdapter)object);
                continue;
            }
            if (object instanceof Iterable) {
                this.add(Iterables.toArray((Iterable)object, Object.class));
                continue;
            }
            this.addSingleton(object);
        }
        return this;
    }

    public void addIfMissing(Object object, Class<?> objectType) {
        if (this.getComponentByType(objectType) == null) {
            this.add(object);
        }
    }

    @Override
    public ComponentContainer addSingletons(Iterable<?> components) {
        for (Object component : components) {
            this.addSingleton(component);
        }
        return this;
    }

    public ComponentContainer addSingleton(Object component) {
        return this.addComponent(component, true);
    }

    public ComponentContainer addComponent(Object component, boolean singleton) {
        Object key = this.componentKeys.of(component);
        if (component instanceof ComponentAdapter) {
            this.pico.addAdapter((ComponentAdapter)component);
        } else {
            try {
                this.pico.as(singleton ? Characteristics.CACHE : Characteristics.NO_CACHE).addComponent(key, component, new Parameter[0]);
            }
            catch (Throwable t) {
                throw new IllegalStateException("Unable to register component " + ComponentContainer.getName(component), t);
            }
            this.declareExtension(null, component);
        }
        return this;
    }

    public ComponentContainer addExtension(@Nullable PluginInfo pluginInfo, Object extension) {
        Object key = this.componentKeys.of(extension);
        try {
            this.pico.as(Characteristics.CACHE).addComponent(key, extension, new Parameter[0]);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unable to register extension " + ComponentContainer.getName(extension), t);
        }
        this.declareExtension(pluginInfo, extension);
        return this;
    }

    private static String getName(Object extension) {
        if (extension instanceof Class) {
            return ((Class)extension).getName();
        }
        return ComponentContainer.getName(extension.getClass());
    }

    public void declareExtension(@Nullable PluginInfo pluginInfo, Object extension) {
        this.propertyDefinitions.addComponent(extension, pluginInfo != null ? pluginInfo.getName() : "");
    }

    public ComponentContainer addPicoAdapter(ComponentAdapter<?> adapter) {
        this.pico.addAdapter(adapter);
        return this;
    }

    @Override
    public <T> T getComponentByType(Class<T> type) {
        return this.pico.getComponent(type);
    }

    public Object getComponentByKey(Object key) {
        return this.pico.getComponent(key);
    }

    public <T> List<T> getComponentsByType(Class<T> tClass) {
        return this.pico.getComponents(tClass);
    }

    public ComponentContainer createChild() {
        return new ComponentContainer(this);
    }

    public static MutablePicoContainer createPicoContainer() {
        ReflectionLifecycleStrategy lifecycleStrategy = new ReflectionLifecycleStrategy(new NullComponentMonitor(), "start", "stop", "close"){

            @Override
            public void start(Object component) {
                Profiler profiler = Profiler.createIfTrace(Loggers.get(ComponentContainer.class));
                profiler.start();
                super.start(component);
                profiler.stopTrace(component.getClass().getCanonicalName() + " started");
            }
        };
        return new ExtendedDefaultPicoContainer((ComponentFactory)new OptInCaching(), (LifecycleStrategy)lifecycleStrategy, null);
    }

    public ComponentContainer getParent() {
        return this.parent;
    }

    public MutablePicoContainer getPicoContainer() {
        return this.pico;
    }

    public int size() {
        return this.pico.getComponentAdapters().size();
    }

    private static final class ExtendedDefaultPicoContainer
    extends DefaultPicoContainer {
        private ExtendedDefaultPicoContainer(ComponentFactory componentFactory, LifecycleStrategy lifecycleStrategy, PicoContainer parent) {
            super(componentFactory, lifecycleStrategy, parent);
        }

        private ExtendedDefaultPicoContainer(ComponentFactory componentFactory, LifecycleStrategy lifecycleStrategy, PicoContainer parent, ComponentMonitor componentMonitor) {
            super(componentFactory, lifecycleStrategy, parent, componentMonitor);
        }

        @Override
        public Object getComponent(Object componentKeyOrType, Class<? extends Annotation> annotation) {
            try {
                return super.getComponent(componentKeyOrType, annotation);
            }
            catch (Throwable t) {
                throw new IllegalStateException("Unable to load component " + componentKeyOrType, t);
            }
        }

        @Override
        public MutablePicoContainer makeChildContainer() {
            ExtendedDefaultPicoContainer pc = new ExtendedDefaultPicoContainer(this.componentFactory, this.lifecycleStrategy, (PicoContainer)this, this.componentMonitor);
            this.addChildContainer(pc);
            return pc;
        }
    }
}

